/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.handlers;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.handlers.HandlerBase;
import org.orecruncher.environs.scanner.AlwaysOnBlockEffectScanner;
import org.orecruncher.environs.scanner.ClientPlayerLocus;
import org.orecruncher.environs.scanner.RandomBlockEffectScanner;
import org.orecruncher.lib.events.BlockUpdateEvent;
import org.orecruncher.lib.events.DiagnosticEvent;
import org.orecruncher.lib.math.LoggingTimerEMA;

@OnlyIn(value=Dist.CLIENT)
class AreaBlockEffects
extends HandlerBase {
    protected final LoggingTimerEMA blockChange = new LoggingTimerEMA("Area Block Update");
    protected ClientPlayerLocus locus;
    protected RandomBlockEffectScanner nearEffects;
    protected RandomBlockEffectScanner farEffects;
    protected AlwaysOnBlockEffectScanner alwaysOn;
    protected long nanos;

    public AreaBlockEffects() {
        super("Area Block Effects");
    }

    @Override
    public void process(@Nonnull PlayerEntity player) {
        this.nearEffects.tick();
        this.farEffects.tick();
        this.alwaysOn.tick();
        this.blockChange.update(this.nanos);
        this.nanos = 0L;
    }

    @Override
    public void onConnect() {
        this.locus = new ClientPlayerLocus();
        this.nearEffects = new RandomBlockEffectScanner(this.locus, 16);
        this.farEffects = new RandomBlockEffectScanner(this.locus, 32);
        this.alwaysOn = new AlwaysOnBlockEffectScanner(this.locus, Config.CLIENT.effects.get_effectRange());
    }

    @Override
    public void onDisconnect() {
        this.locus = null;
        this.nearEffects = null;
        this.farEffects = null;
        this.alwaysOn = null;
    }

    @SubscribeEvent
    public void onDiagnostics(@Nonnull DiagnosticEvent event) {
        if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
            event.addRenderTimer(this.blockChange);
        }
    }

    @SubscribeEvent
    public void onBlockUpdate(@Nonnull BlockUpdateEvent event) {
        long start = System.nanoTime();
        event.getExpandedPositions().forEach(this.alwaysOn::onBlockUpdate);
        this.nanos += System.nanoTime() - start;
    }
}

